/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui.paint;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.GraphicsConfiguration;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.Timer;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class BouncingBall
extends Applet
implements ActionListener,
KeyListener {
    private Button go = new Button("Go");
    private TransformGroup objTrans;
    private Transform3D trans = new Transform3D();
    private float height = 0.0f;
    private float sign = 1.0f;
    private Timer timer;
    private float xloc = 0.0f;

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        this.objTrans = new TransformGroup();
        this.objTrans.setCapability(18);
        objRoot.addChild(this.objTrans);
        Sphere sphere = new Sphere(0.25f, 3, 256);
        this.objTrans = new TransformGroup();
        this.objTrans.setCapability(18);
        Transform3D pos1 = new Transform3D();
        pos1.setTranslation(new Vector3f(0.0f, 0.0f, 0.0f));
        this.objTrans.setTransform(pos1);
        this.objTrans.addChild(sphere);
        objRoot.addChild(this.objTrans);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Color3f light1Color = new Color3f(1.0f, 0.0f, 0.2f);
        Vector3f light1Direction = new Vector3f(4.0f, -7.0f, -12.0f);
        DirectionalLight light1 = new DirectionalLight(light1Color, light1Direction);
        light1.setInfluencingBounds(bounds);
        objRoot.addChild(light1);
        Color3f ambientColor = new Color3f(1.0f, 1.0f, 1.0f);
        AmbientLight ambientLightNode = new AmbientLight(ambientColor);
        ambientLightNode.setInfluencingBounds(bounds);
        objRoot.addChild(ambientLightNode);
        return objRoot;
    }

    public BouncingBall() {
        this.setLayout(new BorderLayout());
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.add("Center", c);
        c.addKeyListener(this);
        this.timer = new Timer(25, this);
        Panel p = new Panel();
        p.add(this.go);
        this.add("North", p);
        this.go.addActionListener(this);
        this.go.addKeyListener(this);
        BranchGroup scene = this.createSceneGraph();
        SimpleUniverse u = new SimpleUniverse(c);
        u.getViewingPlatform().setNominalViewingTransform();
        u.addBranchGraph(scene);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyChar() == 's') {
            this.xloc += 0.1f;
        }
        if (e.getKeyChar() == 'a') {
            this.xloc -= 0.1f;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.go) {
            if (!this.timer.isRunning()) {
                this.timer.start();
            }
        } else {
            this.height = (float)((double)this.height + 0.1 * (double)this.sign);
            if (Math.abs(this.height * 2.0f) >= 1.0f) {
                this.sign = -1.0f * this.sign;
            }
            if (this.height < -0.4f) {
                this.trans.setScale(new Vector3d(1.0, 0.8, 1.0));
            } else {
                this.trans.setScale(new Vector3d(1.0, 1.0, 1.0));
            }
            this.trans.setTranslation(new Vector3f(this.xloc, this.height, 0.0f));
            this.objTrans.setTransform(this.trans);
        }
    }

    public static void main(String[] args) {
        System.out.println("Program Started");
        BouncingBall bb = new BouncingBall();
        bb.addKeyListener(bb);
        MainFrame mf = new MainFrame(bb, 800, 800);
    }
}

